const { CellGroup } = require("../models/CellGroup"); // Ensure CellGroup model is defined

// Get all cell groups
exports.getCellGroups = async (req, res) => {
  try {
    const groups = await CellGroup.findAll();
    res.status(200).json(groups);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};

// Get a single cell group by ID
exports.getCellGroupById = async (req, res) => {
  try {
    const group = await CellGroup.findByPk(req.params.id);
    if (!group) return res.status(404).json({ message: "Cell group not found" });
    res.status(200).json(group);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};

// Create a new cell group
exports.createCellGroup = async (req, res) => {
  try {
    const newGroup = await CellGroup.create(req.body);
    res.status(201).json(newGroup);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};

// Update a cell group
exports.updateCellGroup = async (req, res) => {
  try {
    const group = await CellGroup.findByPk(req.params.id);
    if (!group) return res.status(404).json({ message: "Cell group not found" });

    await group.update(req.body);
    res.status(200).json(group);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};

// Delete a cell group
exports.deleteCellGroup = async (req, res) => {
  try {
    const group = await CellGroup.findByPk(req.params.id);
    if (!group) return res.status(404).json({ message: "Cell group not found" });

    await group.destroy();
    res.status(200).json({ message: "Cell group deleted successfully" });
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};
// module.exports = {
//   deleteCellGroup,
//   updateCellGroup,
//   createCellGroup,
//   getCellGroupById,
//   getCellGroups,
// };