const express = require("express");
const router = express.Router();
const { getPrayerRequests, createPrayerRequest, updatePrayerRequest, deletePrayerRequest } = require("../controllers/prayerController");

router.get("/", getPrayerRequests);
router.post("/", createPrayerRequest);
router.put("/:id", updatePrayerRequest);
router.delete("/:id", deletePrayerRequest);

module.exports = router;
