const express = require("express");

const {
    getAllEvents,
    getEventById,
    createEvent,
    updateEvent,
    deleteEvent,
    getLatestEvents
  }= require("../controllers/eventController");
  const router = express.Router();
  
router.get("/latest-events", getLatestEvents);  
router.get("/", getAllEvents);
router.get("/:id", getEventById);
router.post("/", createEvent);
router.put("/:id", updateEvent);
router.delete("/:id", deleteEvent);

module.exports = router;