const { DataTypes } = require('sequelize');
const sequelize = require('../config/db'); // Import sequelize correctly

const Event = sequelize.define('Event', {
    eventId: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true
    },
    title: DataTypes.STRING,
    description: DataTypes.TEXT,  // Assuming description is a string and not an array
    // eventId: DataTypes.INTEGER,  // Matching the frontend's `eventGroupId`
    date: DataTypes.DATE,  // Changed from event_date to date
    venue: DataTypes.STRING,  // Matching the frontend's venue
    image: DataTypes.STRING,  // Changed from banner_url to bannerUrl
    startTime: DataTypes.TIME,  // Added startTime
    endTime: DataTypes.TIME     // Added endTime
}, {
    timestamps: false,
    tableName: 'events'
});

module.exports = Event;
