const express = require("express");
const {
  getInquiries,
  getInquiryById,
  createInquiry,
  updateInquiry,
  deleteInquiry,
} = require("../controllers/inquiriesController");

const router = express.Router();

router.get("/", getInquiries); // Fetch all inquiries
router.get("/:id", getInquiryById); // Fetch a single inquiry by ID
router.post("/", createInquiry); // Create a new inquiry
router.put("/:id", updateInquiry); // Update an inquiry
router.delete("/:id", deleteInquiry); // Delete an inquiry

module.exports = router;
