const { DataTypes } = require("sequelize");
const sequelize = require("../config/db");

const PrayerRequest = sequelize.define("PrayerRequest", {
    requestId: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
    },
    memberName: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    memberId: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    requestText: {
        type: DataTypes.TEXT,
        allowNull: false,
    },
    requestStatus: {
        type: DataTypes.STRING,
        allowNull: false,
        defaultValue: "Pending",
    }
}, {
    timestamps: true,
    tableName: "prayer_requests",
});

module.exports = PrayerRequest;
