const express = require("express");
const {
  getUsers,
  getUserById,
  createUser,
  updateUser,
  deleteUser,
  approveUser,
  getUnapprovedUsers,
} = require("../controllers/userController");

const protect = require("../middleware/authMiddleware");
const role = require("../middleware/roleMiddleware");

const router = express.Router();

router.get("/", protect, role("admin", "superadmin"), getUsers);
router.get(
  "/unapproved",
  protect,
  role("admin", "superadmin"),
  getUnapprovedUsers
);
router.put("/:id/approve", protect, role("admin", "superadmin"), approveUser);

router.get("/:id", protect, getUserById);
router.post("/", protect, role("superadmin"), createUser);
router.put("/:id", protect, role("admin", "superadmin"), updateUser);
router.delete("/:id", protect, role("superadmin"), deleteUser);

module.exports = router;
