const { DataTypes } = require("sequelize");
const db = require("../config/db");

const Inquiry = db.define("Inquiry", {
  id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
  memberName: { type: DataTypes.STRING, allowNull: false },
  memberId: { type: DataTypes.STRING, allowNull: false },
  email: { type: DataTypes.STRING, allowNull: false },
  mobNo: { type: DataTypes.STRING, allowNull: false },
  inquiryType: { type: DataTypes.STRING, allowNull: false },
  subject: { type: DataTypes.STRING, allowNull: false },
  status: { type: DataTypes.STRING, defaultValue: "Pending" },
}, {
  timestamps: true,
});

module.exports = Inquiry;
