// controllers/eventController.js

const Event= require("../models/Event");

// Fetch all events
exports.getAllEvents = async (req, res) => {
    try {
        const events = await Event.findAll();
        res.json(events);
    } catch (error) {
        res.status(500).json({ message: "Error fetching events", error: error.message });
    }
};

// Get a single event by ID
exports.getEventById = async (req, res) => {
    try {
        const event = await Event.findByPk(req.params.id);
        if (!event) return res.status(404).json({ message: "Event not found" });
        res.json(event);
    } catch (error) {
        res.status(500).json({ message: "Error fetching event", error: error.message });
    }
};

// Create a new event
exports.createEvent = async (req, res) => {
    try {
        const { title, description, venue, date, startTime, endTime } = req.body;
        const newEvent = await Event.create({ title, description, venue, date, startTime, endTime });
        res.status(201).json({ message: "Event created successfully", data: newEvent });
    } catch (error) {
        res.status(500).json({ message: "Error creating event", error: error.message });
    }
};

// Update an event
exports.updateEvent = async (req, res) => {
    try {
        const { title, description, venue, date, startTime, endTime } = req.body;
        const event = await Event.findByPk(req.params.id);
        if (!event) return res.status(404).json({ message: "Event not found" });

        await event.update({ title, description, venue, date, startTime, endTime });
        res.json({ message: "Event updated successfully", data: event });
    } catch (error) {
        res.status(500).json({ message: "Error updating event", error: error.message });
    }
};

// Delete an event
exports.deleteEvent = async (req, res) => {
    try {
        const event = await Event.findByPk(req.params.id);
        if (!event) return res.status(404).json({ message: "Event not found" });

        await event.destroy();
        res.json({ message: "Event deleted successfully" });
    } catch (error) {
        res.status(500).json({ message: "Error deleting event", error: error.message });
    }
};

